//=============================================================================
// Keke_TrueWeaponForce - 真なる武器のチカラ
// バージョン: 1.0.2
//=============================================================================
// Copyright (c) 2020 ケケー
// Released under the MIT license
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @target MZ
 * @plugindesc ショップで装備の真の性能を表示する
 * @author ケケー
 * @url https://kekeelabo.com
 * 
 * @help
 * 【ver.1.0.2】
 * ショップで装備の真のチカラ(特徴込み)を表示する
 *
 * ● 利用規約 ●
 * MITライセンスのもと、自由に使ってくれて大丈夫です
 * 
 * 
 * 
 * Show your gear's true power (features included) in the shop
 *
 * ● Terms of Use ●
 * Feel free to use it under the MIT license.
 */
 
 
 
(() => {

    //- アクターのパラメータ変化量の描画(再定義)
    Window_ShopStatus.prototype.drawActorParamChange = function(
    x, y, actor, item1) {
        const width = this.innerWidth - this.itemPadding() - x;
        const paramId = this.paramId();
        const change = equipChangeForce(actor, paramId, this._item);
        this.changeTextColor(ColorManager.paramchangeTextColor(change));
        this.drawText((change > 0 ? "+" : "") + change, x, y, width, "right");
    };
    
    
    //- 装備による変化量
    function equipChangeForce(actor, paramId, newItem) {
        const tempActor = JsonEx.makeDeepCopy(actor);
        tempActor.forceChangeEquip(newItem.etypeId - 1, newItem);
        return tempActor.param(paramId) - actor.param(paramId);
    };
    
})();